import sprites.utils.*;
import sprites.*;

class ScrollingSpriteLayer{
 
  private boolean _isSeamless;
  private int _zIndex;
  private float _speed;
  private int _imgWidth;
  
  private Sprite _layerImage1;
  private Sprite _layerImage2;
  
  //Constructor
  public ScrollingSpriteLayer(PApplet theApplet, String imgName, int cols, boolean isSeamless, float xPos, float yPos, float speed, int zIndex, float scale){
    
   _isSeamless = isSeamless;
   _speed = speed;
   _zIndex = zIndex;
   
   _layerImage1 = new Sprite(theApplet, imgName, cols, 1, _zIndex);
   _layerImage1.setXY(xPos, yPos);
   _layerImage1.setFrameSequence(0, 0, 1f);
   _layerImage1.setScale(scale);

   
   if(_isSeamless){
      PImage layerPImage = loadImage(imgName);
      _imgWidth = layerPImage.width;
     _layerImage2 = new Sprite(theApplet, imgName, 1, 1, _zIndex);
     _layerImage2.setXY(xPos + _imgWidth, yPos);
     _layerImage2.setScale(scale);
   }

  }
  
  public void update(){
   
    _layerImage1.setX(_layerImage1.getX() - _speed);
    
    if(_isSeamless){
      _layerImage2.setX(_layerImage2.getX() - _speed);
      
      //check if either layer should be reset
       if(_layerImage2.getX() < imageW/2 && _layerImage1.getX() < imageW/2){
          _layerImage1.setX(_layerImage2.getX() + _imgWidth);
       }
       
       if(_layerImage1.getX() < imageW/2 && _layerImage2.getX() < imageW/2){
          _layerImage2.setX(_layerImage1.getX() + _imgWidth);
       }
      
    }else{
      
       if(_layerImage1.getX() < (imageW/2)*-1){
          _layerImage1.setX(width + imageW/2);
       }
    }
  
  }
  
  
}
